import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const NightConnectionIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11.2511 7.64715C10.366 9.06184 8.79613 9.99996 7.00599 9.99996C4.24268 9.99996 2 7.75728 2 4.99397C2 2.34481 4.05846 0.176211 6.66258 0C5.65137 0.825988 5.00359 2.08249 5.00359 3.49218C5.00359 5.98015 7.02101 7.99757 9.50898 7.99757C10.1267 7.99757 10.7154 7.87342 11.2511 7.64715Z"
            fill={props.fill}
        />
    </svg>
);

NightConnectionIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default NightConnectionIcon;
