import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SearchIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.6875 9.375C2.09867 9.375 0 7.27633 0 4.6875C0 2.09867 2.09867 0 4.6875 0C7.27633 0 9.375 2.09867 9.375 4.6875C9.375 5.71123 9.04683 6.65831 8.48994 7.42928L11.4053 10.3447C11.6982 10.6376 11.6982 11.1124 11.4053 11.4053C11.1124 11.6982 10.6376 11.6982 10.3447 11.4053L7.42928 8.48994C6.65831 9.04683 5.71123 9.375 4.6875 9.375ZM4.6875 7.875C6.44791 7.875 7.875 6.44791 7.875 4.6875C7.875 2.92709 6.44791 1.5 4.6875 1.5C2.92709 1.5 1.5 2.92709 1.5 4.6875C1.5 6.44791 2.92709 7.875 4.6875 7.875Z"
            fill={props.fill}
        />
    </svg>
);

SearchIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default SearchIcon;
