import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SortDescendingIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M2 9C2 9.55228 2.44772 10 3 10H5C5.55228 10 6 9.55228 6 9C6 8.44772 5.55228 8 5 8H3C2.44772 8 2 8.44772 2 9ZM2 6C2 6.55228 2.44772 7 3 7H7C7.55228 7 8 6.55228 8 6C8 5.44772 7.55228 5 7 5H3C2.44772 5 2 5.44772 2 6ZM2 3C2 3.55228 2.44772 4 3 4H9C9.55228 4 10 3.55228 10 3C10 2.44772 9.55228 2 9 2H3C2.44772 2 2 2.44772 2 3Z"
            fill={props.fill}
        />
    </svg>
);

SortDescendingIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default SortDescendingIcon;
