import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const WarningFilledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6 12C9.31371 12 12 9.31371 12 6C12 2.68629 9.31371 0 6 0C2.68629 0 0 2.68629 0 6C0 9.31371 2.68629 12 6 12ZM7 9.03447C7 8.47955 6.57827 8.08002 6.04555 8.08002C5.50174 8.08002 5.08 8.47955 5.08 9.03447C5.08 9.58938 5.50174 10 6.04555 10C6.57827 10 7 9.58938 7 9.03447ZM6.65176 2C6.84158 2 6.99308 2.15827 6.98478 2.3479L6.78061 7.01456C6.77281 7.19282 6.62603 7.33333 6.4476 7.33333H5.55231C5.37388 7.33333 5.22709 7.19282 5.2193 7.01456L5.01521 2.3479C5.00692 2.15827 5.15842 2 5.34823 2H6.65176Z"
            fill={props.fill}
        />
    </svg>
);

WarningFilledIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default WarningFilledIcon;
