import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const AdultIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8 2.5C8.69036 2.5 9.25 1.94036 9.25 1.25C9.25 0.559644 8.69036 0 8 0C7.30964 0 6.75 0.559644 6.75 1.25C6.75 1.94036 7.30964 2.5 8 2.5ZM6 10C5.44772 10 5 9.55228 5 9V4.77069C5 4.03743 5.53012 3.41165 6.2534 3.2911L6.84921 3.1918C7.61115 3.06481 8.38885 3.06481 9.15079 3.1918L9.7466 3.2911C10.4699 3.41165 11 4.03743 11 4.77069V9C11 9.55229 10.5523 10 10 10V15C10 15.5523 9.55228 16 9 16C8.44772 16 8 15.5523 8 15C8 15.5523 7.55228 16 7 16C6.44772 16 6 15.5523 6 15L6 10Z"
            fill={props.fill}
        />
    </svg>
);

AdultIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default AdultIcon;
