import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const AllInclusiveIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M13.501 6.66667C12.8053 8 11.8053 8.66667 10.501 8.66667C9.19663 8.66667 8.19663 8 7.50098 6.66667L7.74621 0.399681C7.75494 0.176405 7.93455 0 8.15315 0H8.42038C8.48988 0 8.54718 0.0557137 8.55065 0.126675L8.77272 4.66667H9.88141L10.1035 0.126675C10.1069 0.0557137 10.1642 0 10.2337 0H10.7682C10.8377 0 10.895 0.0557137 10.8985 0.126675L11.1205 4.66667H12.2292L12.4513 0.126675C12.4548 0.0557137 12.5121 0 12.5816 0H12.8488C13.0674 0 13.247 0.176405 13.2557 0.399681L13.501 6.66667ZM11.2246 9.23627L11.3945 15.3143C11.4048 15.6823 11.1212 15.9892 10.7612 15.9997C10.755 15.9999 10.7488 16 10.7426 16H10.2586C9.89843 16 9.60645 15.7015 9.60645 15.3333C9.60645 15.327 9.60653 15.3206 9.60671 15.3143L9.77659 9.23627C10.0179 9.30098 10.2593 9.33333 10.5006 9.33333C10.7419 9.33333 10.9833 9.30098 11.2246 9.23627ZM6.0013 0.703641V16H5.52237C4.78599 16 4.18903 15.4031 4.18903 14.6667C4.18903 14.6489 4.18939 14.6311 4.1901 14.6134L4.4013 9.33334C4.13464 8.64053 3.55686 8.19609 2.66797 8C2.66797 4.45212 3.39143 1.87162 4.83835 0.258497L4.83834 0.258489C5.08419 -0.0156018 5.50568 -0.0384954 5.77978 0.207355C5.92076 0.33381 6.0013 0.514257 6.0013 0.703641Z"
            fill={props.fill}
        />
    </svg>
);

AllInclusiveIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default AllInclusiveIcon;
