import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowLongRightIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M9.29 3.90806C9.10236 3.72042 8.99694 3.46592 8.99694 3.20056C8.99694 2.93519 9.10236 2.6807 9.29 2.49306C9.47764 2.30542 9.73214 2.2 9.9975 2.2C10.2629 2.2 10.5174 2.30542 10.705 2.49306L15.503 7.29206C15.6905 7.47958 15.7958 7.73389 15.7958 7.99906C15.7958 8.26422 15.6905 8.51853 15.503 8.70606L10.704 13.5041C10.5164 13.6916 10.2619 13.7969 9.99665 13.7968C9.73138 13.7967 9.47701 13.6912 9.2895 13.5036C9.10199 13.3159 8.9967 13.0615 8.9968 12.7962C8.99689 12.5309 9.10236 12.2766 9.29 12.0891L10.703 10.6771C11.2349 10.1458 11.8249 9.67616 12.462 9.27706L13.209 8.80706L13.162 8.76106L12.203 8.89806C11.7346 8.9648 11.2621 8.99821 10.789 8.99806H1C0.734784 8.99806 0.48043 8.8927 0.292893 8.70516C0.105357 8.51763 0 8.26327 0 7.99806C0 7.73284 0.105357 7.47849 0.292893 7.29095C0.48043 7.10341 0.734784 6.99806 1 6.99806H10.79C11.2631 6.99823 11.7357 7.03198 12.204 7.09906L13.164 7.23606L13.21 7.18906L12.46 6.71906C11.824 6.32015 11.2349 5.85086 10.704 5.32006L9.29 3.90806Z"
            fill={props.fill}
        />
    </svg>
);

ArrowLongRightIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ArrowLongRightIcon;
