import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowTopIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M8 6.41764L3.20687 11.2075C2.81621 11.5979 2.18304 11.5977 1.79265 11.207C1.40226 10.8164 1.40248 10.1832 1.79313 9.79281L7.29313 4.29656C7.6836 3.90636 8.3164 3.90636 8.70687 4.29656L14.2069 9.79281C14.5975 10.1832 14.5977 10.8164 14.2073 11.207C13.817 11.5977 13.1838 11.5979 12.7931 11.2075L8 6.41764Z"
            fill={props.fill}
        />
    </svg>
);

ArrowTopIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ArrowTopIcon;
