import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BackArrowIcon = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 16 16" fill="none" {...props}>
        <path
            d="M2.418 8l4.79 4.793a1 1 0 0 1-1.415 1.414l-5.496-5.5a1 1 0 0 1 0-1.414l5.496-5.5a1 1 0 0 1 1.415 1.414L2.418 8z"
            fill={props.fill}
        />
    </svg>
);

BackArrowIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};
export default BackArrowIcon;
