import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BathroomIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M12 1.14286C12 1.77404 11.4884 2.28571 10.8572 2.28571C10.226 2.28571 9.71431 1.77404 9.71431 1.14286C9.71431 0.511675 10.226 0 10.8572 0C11.4884 0 12 0.511675 12 1.14286Z"
            fill={props.fill}
        />
        <path
            d="M8.85717 4.57143C9.33055 4.57143 9.71431 4.18767 9.71431 3.71429C9.71431 3.2409 9.33055 2.85714 8.85717 2.85714C8.38378 2.85714 8.00002 3.2409 8.00002 3.71429C8.00002 4.18767 8.38378 4.57143 8.85717 4.57143Z"
            fill={props.fill}
        />
        <path
            d="M13.7143 4.57143C13.7143 5.20261 13.2026 5.71429 12.5715 5.71429C11.9403 5.71429 11.4286 5.20261 11.4286 4.57143C11.4286 3.94025 11.9403 3.42857 12.5715 3.42857C13.2026 3.42857 13.7143 3.94025 13.7143 4.57143Z"
            fill={props.fill}
        />
        <path
            d="M1.14288 5.88571C3.33615 5.88571 5.11344 6.26103 7.68791 7.10798C11.1791 8.25651 11.4835 8.34242 12.8587 8.39833C13.6157 8.4291 14.3417 8.34844 15.0612 8.14285C15.4557 8.03014 15.6842 7.61898 15.5714 7.22449C15.4587 6.83001 15.0476 6.60159 14.6531 6.7143C14.0898 6.87522 13.5218 6.93834 12.9191 6.91384C11.7487 6.86626 11.4576 6.78408 8.1522 5.69668C5.44097 4.80473 3.52438 4.4 1.14288 4.4C0.732613 4.4 0.400024 4.73259 0.400024 5.14286C0.400024 5.55313 0.732613 5.88571 1.14288 5.88571Z"
            fill={props.fill}
        />
        <path
            d="M1.14288 6.85714C3.76356 6.85714 5.90348 7.57828 7.89337 8.24885C10.2424 9.04044 12.3823 9.76158 14.8572 9.14286C14.8572 11.1778 14.2656 12.3253 13.0825 12.9618L13.7143 14.8571H12.8081C12.6566 14.8571 12.5112 14.7969 12.4041 14.6898L11.9307 14.2164C11.6092 13.8949 11.1732 13.7143 10.7185 13.7143H8.00002C7.66083 13.7143 7.33422 13.7111 7.02019 13.7027C6.96694 13.7104 6.91251 13.7143 6.85717 13.7143H5.28153C4.82688 13.7143 4.39084 13.8949 4.06935 14.2164L3.59596 14.6898C3.4888 14.7969 3.34345 14.8571 3.1919 14.8571H2.28574L2.98972 12.7452C1.7585 11.8423 1.14288 10.1192 1.14288 6.85714Z"
            fill={props.fill}
        />
    </svg>
);

BathroomIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default BathroomIcon;
