import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BeachIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8.37603 7.75588L9.72402 11.4595C9.26142 11.4554 8.80034 11.4838 8.33513 11.5419L7.1225 8.21025C7.32024 8.135 7.52159 8.06008 7.72656 7.98548C7.94584 7.90566 8.16233 7.82913 8.37603 7.75588ZM5.76138 0.438835L5.89371 0.802428C5.6605 0.83246 5.4354 0.885336 5.21841 0.961057C5.01539 1.03191 4.81979 1.12265 4.63163 1.23327L4.50845 0.894861C4.38253 0.548876 4.56092 0.166315 4.9069 0.0403864C5.25289 -0.085542 5.63545 0.0928494 5.76138 0.438835ZM14.3458 5.06269C13.4062 3.67208 10.8388 0.737379 6.27947 1.51468C6.94483 2.15933 7.79347 3.49742 8.8254 5.52895C8.27843 5.70047 7.71335 5.89243 7.13001 6.10475C6.54407 6.31802 5.98536 6.5352 5.45382 6.75647C4.93533 4.52341 4.72588 2.94725 4.82547 2.02799C0.759543 4.3585 0.677747 8.29551 0.853022 9.97451C0.891592 10.344 1.32091 10.4998 1.62538 10.287C2.56435 9.63069 4.52914 8.41561 7.53234 7.32253C10.5333 6.23027 12.8148 5.89908 13.9546 5.79881C14.3249 5.76624 14.5539 5.37067 14.3458 5.06269ZM3.33266 13.7766C3.11252 13.8507 2.89065 13.9254 2.66669 14C2.66669 14.3682 2.96516 14.6667 3.33335 14.6667H13.3334C14.0697 14.6667 14.6667 14.0697 14.6667 13.3333C10.2613 11.4453 7.04414 12.5278 3.33266 13.7766Z"
            fill={props.fill}
        />
    </svg>
);

BeachIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default BeachIcon;
