import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BoatIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#0cc98661__clip0_11628_2)">
            <path
                d="M8.71324 0.278534L9.13348 2H6.86682L7.28706 0.278534C7.31385 0.117804 7.45291 0 7.61586 0H8.38444C8.54739 0 8.68645 0.117804 8.71324 0.278534Z"
                fill={props.fill}
            />
            <path
                d="M2.62965 5.30017L2.3335 7.70097L7.5439 6C7.83863 5.89297 8.16169 5.89297 8.45643 6L13.6668 7.70097L13.3707 5.30017C13.3536 5.12977 13.21 5 13.0385 5H10.4198C10.3461 5 10.2863 4.9403 10.2863 4.86667C10.2863 4.80548 10.328 4.75215 10.3874 4.73731L12.1 4L12.0001 3.27853C11.9733 3.1178 11.8341 3 11.6709 3H4.32924C4.16607 3 4.02682 3.1178 4 3.27853L3.9 4L5.61289 4.73731C5.67233 4.75215 5.71402 4.80548 5.71402 4.86667C5.71402 4.9403 5.65425 5 5.58051 5H2.96177C2.79029 5 2.64671 5.12977 2.62965 5.30017Z"
                fill={props.fill}
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M0.417159 10.0365L7.74105 7.04558C7.90682 6.97789 8.09311 6.97789 8.25887 7.04558L15.5828 10.0365C15.9276 10.1773 16.0913 10.5669 15.9483 10.9065C15.9347 10.9389 15.9185 10.9701 15.8998 11L13.457 15.2552C13.4177 15.3183 13.368 15.3744 13.31 15.4213C12.8329 15.8071 11.9642 16 10.7039 16C9.6899 16 8.84493 15.6671 7.99997 15.3342C7.15501 15.0013 6.31004 14.6684 5.29609 14.6684C4.32848 14.6684 3.59171 14.7821 3.0858 15.0095C2.77528 15.149 2.40788 15.0387 2.22923 14.7522L0.100088 11C-0.0953191 10.6867 0.00414681 10.2767 0.322251 10.0842C0.352563 10.0659 0.384298 10.0499 0.417159 10.0365ZM6 11.25C6.41421 11.25 6.75 10.9142 6.75 10.5C6.75 10.0858 6.41421 9.75 6 9.75C5.58579 9.75 5.25 10.0858 5.25 10.5C5.25 10.9142 5.58579 11.25 6 11.25ZM10 11.25C10.4142 11.25 10.75 10.9142 10.75 10.5C10.75 10.0858 10.4142 9.75 10 9.75C9.58579 9.75 9.25 10.0858 9.25 10.5C9.25 10.9142 9.58579 11.25 10 11.25Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="0cc98661__clip0_11628_2">
                <rect width={16} height={16} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

BoatIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default BoatIcon;
