import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BreakfastIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M15.3333 5.33332V4.99999C15.3333 3.71133 14.2886 2.66666 13 2.66666H12.1446C12.1125 2.66666 12.0804 2.66724 12.0484 2.66839C12.0324 2.66724 12.0163 2.66666 12 2.66666H2.66665C2.29846 2.66666 1.99998 2.96513 1.99998 3.33332C1.99998 7.33332 2.01966 11.3333 7.33331 11.3333C9.31458 11.3333 10.5598 10.7772 11.3425 9.87234C11.4753 9.71884 11.7165 9.42542 11.9277 9.16649C12.1952 8.83859 12.5368 8.5801 12.9039 8.3696C13.7741 7.87051 15.3333 6.77516 15.3333 5.33332ZM12.6656 3.99999H13C13.5523 3.99999 14 4.44771 14 4.99999V5.33332C14 6.0697 13.403 6.66666 12.6666 6.66666H12.539C12.6405 5.82194 12.6613 4.91685 12.6656 3.99999Z"
            fill={props.fill}
        />
        <path
            d="M1.93746 12C1.6038 12 1.33331 12.2705 1.33331 12.6041C1.33331 12.8445 1.47501 13.0604 1.70198 13.1396C2.48989 13.4146 4.49969 14 7.33331 14C10.1669 14 12.1767 13.4146 12.9646 13.1396C13.1916 13.0604 13.3333 12.8445 13.3333 12.6041C13.3333 12.2705 13.0628 12 12.7292 12H1.93746Z"
            fill={props.fill}
        />
    </svg>
);

BreakfastIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default BreakfastIcon;
