import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BusIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M15 7V15.5C15 15.7761 14.7761 16 14.5 16H12.3904C12.161 16 11.961 15.8439 11.9053 15.6213L11.5 14H4.5L4.09468 15.6213C4.03904 15.8439 3.83905 16 3.60961 16H1.5C1.22386 16 1 15.7761 1 15.5V7L0.276393 6.6382C0.107001 6.5535 0 6.38037 0 6.19098V4C0 3.44772 0.447715 3 1 3V2.38791C1 1.52131 1.55811 0.753296 2.38236 0.485672C3.41074 0.151766 5.25532 0 8 0C10.7447 0 12.5893 0.151766 13.6176 0.485672C14.4419 0.753296 15 1.52131 15 2.38791V3C15.5523 3 16 3.44772 16 4V6.19098C16 6.38037 15.893 6.5535 15.7236 6.6382L15 7ZM8 2C5.74605 2 4.03944 2.23836 2.88017 2.71509L2.88018 2.71512C2.52701 2.86035 2.28739 3.19405 2.26264 3.57511L2 7.61758C2 7.86425 2.1799 8.07406 2.42369 8.11171C3.23647 8.23723 5.09524 8.29999 8 8.29999C10.9047 8.29999 12.7635 8.23723 13.5763 8.11172C13.8201 8.07408 14 7.86427 14 7.6176L13.7374 3.57507L13.7373 3.57507C13.7126 3.194 13.473 2.86029 13.1198 2.71506C11.9605 2.23835 10.2539 2 8 2ZM12.5 13C13.3284 13 14 12.3284 14 11.5C14 10.6716 13.3284 10 12.5 10C11.6716 10 11 10.6716 11 11.5C11 12.3284 11.6716 13 12.5 13ZM3.5 13C4.32843 13 5 12.3284 5 11.5C5 10.6716 4.32843 10 3.5 10C2.67157 10 2 10.6716 2 11.5C2 12.3284 2.67157 13 3.5 13Z"
            fill={props.fill}
        />
    </svg>
);

BusIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default BusIcon;
