import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CancelIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8C16 12.4183 12.4183 16 8 16ZM12.8908 11.4765C13.5892 10.4957 14 9.29581 14 8C14 4.68629 11.3137 2 8 2C6.70419 2 5.50432 2.41078 4.52351 3.10922L12.8908 11.4765ZM11.4766 12.8907C10.4958 13.5892 9.29585 14 8 14C4.68629 14 2 11.3137 2 8C2 6.70415 2.4108 5.50425 3.10928 4.52342L11.4766 12.8907Z"
            fill={props.fill}
        />
    </svg>
);

CancelIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default CancelIcon;
