import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CheckIcon = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 16 16" fill="none" focusable={false} {...props}>
        <circle cx="8" cy="8" r="6" fill="#fff" />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.84-3.25a.998.998 0 0 0-1.41.09L6.986 9.26 5.23 7.32a.997.997 0 0 0-1.41-.06 1.009 1.009 0 0 0-.06 1.42l2.131 2.343a1.5 1.5 0 0 0 2.12.085c.053-.052.053-.052.103-.106L12.25 6.16a.998.998 0 0 0-.09-1.41z"
            fill={props.fill}
        />
    </svg>
);

CheckIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};
export default CheckIcon;
