import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CloseIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M1.79289 1.79289C1.40237 2.18342 1.40237 2.81658 1.79289 3.20711L6.58579 8L1.79289 12.7929C1.40237 13.1834 1.40237 13.8166 1.79289 14.2071C2.18342 14.5976 2.81658 14.5976 3.20711 14.2071L8 9.41421L12.7929 14.2071C13.1834 14.5976 13.8166 14.5976 14.2071 14.2071C14.5976 13.8166 14.5976 13.1834 14.2071 12.7929L9.41421 8L14.2071 3.20711C14.5976 2.81658 14.5976 2.18342 14.2071 1.79289C13.8166 1.40237 13.1834 1.40237 12.7929 1.79289L8 6.58579L3.20711 1.79289C2.81658 1.40237 2.18342 1.40237 1.79289 1.79289Z"
            fill={props.fill}
        />
    </svg>
);

CloseIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default CloseIcon;
