import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CoffeeMachineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M14.9333 0.888916H1.06666C0.968477 0.888916 0.888885 0.968507 0.888885 1.06669V3.3778C0.888885 3.47599 0.968477 3.55558 1.06666 3.55558H12.2667C12.3649 3.55558 12.4444 3.63517 12.4444 3.73336V13.1556C12.4444 13.2538 12.3649 13.3334 12.2667 13.3334H1.06666C0.968477 13.3334 0.888885 13.4129 0.888885 13.5111V14.9334C0.888885 15.0316 0.968477 15.1111 1.06666 15.1111H14.9333C15.0316 15.1111 15.1111 15.0316 15.1111 14.9334V1.06669C15.1111 0.968507 15.0316 0.888916 14.9333 0.888916Z"
            fill={props.fill}
            stroke={props.fill}
        />
        <path
            d="M2.66666 1.33336C2.66666 1.0879 2.46768 0.888916 2.22222 0.888916C1.97676 0.888916 1.77777 1.0879 1.77777 1.33336V3.11114C1.77777 3.3566 1.97676 3.55558 2.22222 3.55558C2.46768 3.55558 2.66666 3.3566 2.66666 3.11114V1.33336Z"
            fill="white"
        />
        <path
            d="M4.44443 1.33336C4.44443 1.0879 4.24545 0.888916 3.99999 0.888916C3.75453 0.888916 3.55554 1.0879 3.55554 1.33336V3.11114C3.55554 3.3566 3.75453 3.55558 3.99999 3.55558C4.24545 3.55558 4.44443 3.3566 4.44443 3.11114V1.33336Z"
            fill="white"
        />
        <path
            d="M3.55554 3.55554H9.77776C9.77776 4.53738 8.98185 5.33332 7.99999 5.33332H5.33332C4.35148 5.33332 3.55554 4.53738 3.55554 3.55554Z"
            fill={props.fill}
        />
        <path
            d="M5.77777 5.33335C5.77777 4.84243 6.17574 4.44446 6.66666 4.44446C7.15758 4.44446 7.55555 4.84243 7.55555 5.33335V6.22224C7.55555 6.71315 7.15758 7.11112 6.66666 7.11112C6.17574 7.11112 5.77777 6.71315 5.77777 6.22224V5.33335Z"
            fill={props.fill}
        />
    </svg>
);

CoffeeMachineIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default CoffeeMachineIcon;
