import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CopyIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M10 11.9999C10.5523 11.9999 11 12.4476 11 12.9998V13.5027C11 14.3312 10.3284 15.0027 9.5 15.0027H2.5C1.67157 15.0027 1 14.3312 1 13.5027V6.50275C1 5.67432 1.67157 5.00275 2.5 5.00275H3C3.55228 5.00275 4 5.45046 4 6.00275C4 6.55503 3.55228 7.00275 3 7.00275V13.0027H9V12.9998C9 12.4476 9.4477 11.9999 10 11.9999Z"
            fill={props.fill}
        />
        <mask id="755e6b52__path-2-inside-1_22294_4862" fill="white">
            <rect x={5} y={1} width={10} height={10} rx={1.5} />
        </mask>
        <rect
            x={5}
            y={1}
            width={10}
            height={10}
            rx={1.5}
            stroke={props.fill}
            strokeWidth={4}
            mask="url(#755e6b52__path-2-inside-1_22294_4862)"
        />
    </svg>
);

CopyIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default CopyIcon;
