import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CovidShildIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8 0C6 1 3.5 2.1383 1 2L1.5 8.83443C1.5 10.3384 2.25442 11.7477 3.52113 12.6101L8 16L12.4789 12.6101C13.7456 11.7477 14.5 10.3384 14.5 8.83443L15 2C12.5 2.1383 10 1 8 0ZM11.1485 3.82451C11.0194 4.08885 10.7173 4.22613 10.3799 4.20765L9.4649 5.79254C9.63563 5.93921 9.78412 6.11104 9.90461 6.30228L11.3486 5.91537C11.6153 5.84389 11.8895 6.00219 11.961 6.26892C12.0325 6.53565 11.8742 6.80982 11.6074 6.88129L10.2357 7.24885C10.2448 7.33131 10.2495 7.41511 10.2495 7.50001C10.2495 7.67832 10.2288 7.85179 10.1896 8.01814L11.8012 8.94859C12.0527 8.78409 12.3441 8.74637 12.5779 8.87696C12.9518 9.08578 13.0366 9.64595 12.7673 10.1281C12.498 10.6103 11.9766 10.8319 11.6027 10.623C11.3359 10.474 11.2163 10.1461 11.2676 9.7952L9.7471 8.91736C9.5658 9.14062 9.34258 9.32846 9.08943 9.46889L9.69997 11.7475C9.77144 12.0142 9.61315 12.2884 9.34641 12.3598C9.07968 12.4313 8.80551 12.273 8.73404 12.0063L8.1285 9.74637C8.08582 9.74878 8.04283 9.75001 7.99954 9.75001C7.73794 9.75001 7.48677 9.70536 7.25322 9.62327L6.45336 11.0087C6.65282 11.2733 6.70783 11.5937 6.56611 11.8463C6.35655 12.2198 5.79623 12.3034 5.31458 12.0332C4.83293 11.7629 4.61236 11.2411 4.82191 10.8676C4.96104 10.6197 5.25479 10.4995 5.57748 10.5258L6.40683 9.08927C6.21032 8.89233 6.0501 8.65917 5.93705 8.40066L3.67409 9.00702C3.40736 9.07849 3.13319 8.9202 3.06172 8.65347C2.99025 8.38674 3.14854 8.11257 3.41527 8.0411L5.75111 7.41521C5.76049 7.16223 5.81162 6.91993 5.89784 6.69499L5.02515 6.19114C4.76636 6.37923 4.45697 6.42976 4.21034 6.29379C3.83531 6.08704 3.74743 5.52736 4.01406 5.0437C4.2807 4.56004 4.80087 4.33556 5.1759 4.54231C5.43194 4.68346 5.55413 4.98911 5.52106 5.32275L6.45626 5.86269C6.61377 5.71417 6.7927 5.58813 6.98793 5.4897L6.69211 4.38567C6.62064 4.11894 6.77893 3.84477 7.04566 3.7733C7.3124 3.70183 7.58657 3.86012 7.65804 4.12686L7.95908 5.25036C7.97254 5.25013 7.98603 5.25001 7.99954 5.25001C8.20019 5.25001 8.39469 5.27627 8.57982 5.32554L9.48952 3.7499C9.29249 3.50183 9.22865 3.19814 9.35124 2.94705C9.53913 2.56222 10.0938 2.44668 10.5901 2.68898C11.0864 2.93128 11.3364 3.43968 11.1485 3.82451Z"
            fill={props.fill}
        />
    </svg>
);

CovidShildIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default CovidShildIcon;
