import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DelayIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M15.9977 8C15.9977 11.562 13.6493 14.6651 10.2863 15.6676C9.75704 15.8253 9.20009 15.5242 9.04231 14.9949C8.88454 14.4656 9.18569 13.9087 9.71496 13.7509C12.2359 12.9994 13.9977 10.6715 13.9977 8C13.9977 4.68629 11.3114 2 7.99768 2C7.4454 2 6.99768 1.55228 6.99768 1C6.99768 0.447715 7.4454 0 7.99768 0C12.416 0 15.9977 3.58172 15.9977 8ZM1.42572 3.43719C1.34089 3.55917 1.25947 3.68349 1.18155 3.81001C0.891932 4.28027 1.03837 4.89626 1.50863 5.18588C1.97889 5.47549 2.59488 5.32905 2.8845 4.85879C2.94295 4.76388 3.00405 4.6706 3.0677 4.57907C3.38302 4.12565 3.27107 3.50246 2.81765 3.18714C2.36423 2.87182 1.74104 2.98377 1.42572 3.43719ZM8.99768 7.58579L10.7048 9.29289C11.0953 9.68342 11.0953 10.3166 10.7048 10.7071C10.3143 11.0976 9.6811 11.0976 9.29058 10.7071L7.29058 8.70711C7.09531 8.51184 6.99768 8.25592 6.99768 8V4.4987C6.99768 3.94713 7.44155 3.5 7.99768 3.5C8.54997 3.5 8.99768 3.94793 8.99768 4.4987V7.58579ZM0.213508 9.85259C0.0863331 9.31647 0.0145952 8.76601 0.00033268 8.20772C-0.0137718 7.65561 0.422364 7.19661 0.974468 7.1825C1.52657 7.1684 1.98558 7.60453 1.99968 8.15664C2.0104 8.57636 2.06421 8.98925 2.15951 9.39097C2.28698 9.92834 1.95469 10.4673 1.41732 10.5948C0.879944 10.7222 0.340981 10.39 0.213508 9.85259ZM2.50143 13.813C3.41077 14.6731 4.50996 15.311 5.71396 15.669C6.24333 15.8265 6.8001 15.5249 6.95753 14.9956C7.11496 14.4662 6.81345 13.9094 6.28408 13.752C5.38248 13.4839 4.55833 13.0056 3.87571 12.36C3.47447 11.9805 2.84155 11.9981 2.46205 12.3994C2.08255 12.8006 2.10019 13.4336 2.50143 13.813Z"
            fill={props.fill}
        />
    </svg>
);

DelayIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default DelayIcon;
