import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DetailedInfoIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M0 8C0 12.4183 3.58172 16 8 16C12.4183 16 16 12.4183 16 8C16 3.58172 12.4183 0 8 0C3.58172 0 0 3.58172 0 8ZM15 8C15 11.866 11.866 15 8 15C4.13401 15 1 11.866 1 8C1 4.13401 4.13401 1 8 1C11.866 1 15 4.13401 15 8Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7.58758 4.592C7.58758 4.997 7.90658 5.34 8.47058 5.34C9.02258 5.34 9.42758 5.034 9.55058 4.543C9.57458 4.445 9.58759 4.334 9.58759 4.248C9.58759 3.844 9.26759 3.5 8.70359 3.5C8.16359 3.5 7.74659 3.807 7.62358 4.297C7.60024 4.39361 7.58816 4.49261 7.58758 4.592ZM6.22358 11.53C6.22358 11.996 6.49358 12.499 7.31558 12.499C7.78258 12.499 8.32159 12.303 8.91059 11.444L9.47058 10.632C9.50631 10.5772 9.51991 10.511 9.50864 10.4466C9.49737 10.3821 9.46207 10.3244 9.40987 10.2851C9.35766 10.2457 9.29246 10.2276 9.22744 10.2345C9.16242 10.2413 9.10242 10.2726 9.05959 10.322L8.12559 11.465C8.10418 11.4923 8.07403 11.5114 8.04021 11.5191C8.00639 11.5267 7.97095 11.5225 7.93986 11.5072C7.90877 11.4918 7.88392 11.4662 7.86948 11.4347C7.85504 11.4031 7.8519 11.3676 7.86058 11.334L8.97859 6.684C8.99813 6.60327 8.99725 6.51894 8.97603 6.43864C8.95481 6.35833 8.91392 6.28458 8.85705 6.22404C8.80018 6.1635 8.72913 6.11808 8.65031 6.09188C8.57149 6.06569 8.48738 6.05954 8.40559 6.074L6.32358 6.442C6.25609 6.45391 6.19359 6.48537 6.14381 6.53247C6.09404 6.57958 6.05919 6.64027 6.04359 6.707L6.00658 6.862C5.99798 6.89873 5.99781 6.93693 6.00607 6.97374C6.01433 7.01055 6.03081 7.04502 6.05429 7.07455C6.07776 7.10409 6.10761 7.12792 6.14161 7.14428C6.1756 7.16064 6.21286 7.16909 6.25058 7.169H7.19358L6.33358 10.867C6.28558 11.039 6.22358 11.333 6.22358 11.53Z"
            fill={props.fill}
        />
    </svg>
);

DetailedInfoIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default DetailedInfoIcon;
