import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DownloadIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7.45431 12.6712C7.75035 12.9852 8.24965 12.9852 8.54569 12.6712L12.1552 8.84301C12.4559 8.52403 12.2298 8 11.7914 8H10V1C10 0.447715 9.55228 0 9 0H7C6.44772 0 6 0.447715 6 1V8H4.20863C3.77023 8 3.54409 8.52403 3.84483 8.84301L7.45431 12.6712ZM3 14C2.44772 14 2 14.4477 2 15C2 15.5523 2.44772 16 3 16H13C13.5523 16 14 15.5523 14 15C14 14.4477 13.5523 14 13 14H3Z"
            fill={props.fill}
        />
    </svg>
);

DownloadIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default DownloadIcon;
