import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const EditIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M9.8859 4.69752L3.69987 10.8901C3.55304 11.037 3.43831 11.2128 3.36296 11.4063L1.82737 14.1828L4.59748 12.6416C4.79123 12.5661 4.96719 12.4513 5.11418 12.3042L11.3002 6.11982C11.1066 5.84196 10.8872 5.57977 10.6433 5.33581C10.4071 5.09967 10.1539 4.88656 9.8859 4.69752ZM11.3147 3.2672C11.5744 3.46818 11.8224 3.68655 12.0575 3.9216C12.3 4.16418 12.5248 4.4206 12.7311 4.68933L13.8403 3.58047C14.103 3.31773 14.0946 3.13479 13.4803 2.52047C12.866 1.90615 12.6829 1.89788 12.4203 2.16047L11.3147 3.2672ZM14.9003 1.10047C16.2889 2.48911 16.3008 3.93995 15.2503 4.99047L6.52871 13.7181C6.18573 14.0612 5.77515 14.3293 5.32305 14.5053L1.71119 15.9115C1.41953 16.025 1.09588 16.025 0.80422 15.9115C0.160897 15.661 -0.157587 14.9365 0.0928672 14.2931L1.49922 10.6807C1.67504 10.2291 1.94274 9.81894 2.28535 9.47618L11.0103 0.750469C12.0609 -0.300206 13.5116 -0.288171 14.9003 1.10047Z"
            fill={props.fill}
        />
    </svg>
);

EditIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default EditIcon;
