import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ExternalAreaIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M3.53497 0.0252199C3.57925 0.0482876 3.61515 0.0856967 3.63729 0.131832L6.18151 5.43345C6.23802 5.55121 6.19221 5.69441 6.07918 5.75329C6.07351 5.75624 6.06772 5.75895 6.06183 5.7614L3.43264 6.85714L0.803449 5.7614C0.686121 5.71251 0.629053 5.57377 0.683775 5.43345L3.22799 0.131832C3.2845 0.0140716 3.42194 -0.0336603 3.53497 0.0252199Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.85714 1.71429V4.30164L7.19682 4.981C7.46035 5.50806 7.35265 6.12368 6.97283 6.53055L7.83578 9.55089C8.06587 10.3562 7.63593 11.199 6.85714 11.4893V12.5714H4.29524L4.23673 11.1672L6.53482 10.4241C6.77417 10.3467 6.90822 10.1002 6.83891 9.86486L6.01132 7.05494L3.85302 7.91826C3.58055 8.02725 3.27659 8.02725 3.00413 7.91826L0.845824 7.05494L0.0182354 9.86486C-0.0510759 10.1002 0.0829738 10.3467 0.322324 10.4241L2.62041 11.1672L2.5619 12.5714H1.37143C1.24519 12.5714 1.14286 12.6738 1.14286 12.8V13.4857C1.14286 13.612 1.24519 13.7143 1.37143 13.7143H15.7714C15.8977 13.7143 16 13.612 16 13.4857V12.8C16 12.6738 15.8977 12.5714 15.7714 12.5714H14.8571V1.71429C14.8571 1.39869 14.6013 1.14286 14.2857 1.14286H7.42857C7.11298 1.14286 6.85714 1.39869 6.85714 1.71429ZM8.57143 3.42857H10.2857V5.71429H8.57143V3.42857ZM13.1429 3.42857H11.4286V5.71429H13.1429V3.42857ZM8.57143 6.85714H10.2857V9.14286H8.57143V6.85714ZM13.1429 6.85714H11.4286V9.14286H13.1429V6.85714ZM9.71429 11.4286H12V12.5714H9.71429V11.4286Z"
            fill={props.fill}
        />
    </svg>
);

ExternalAreaIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ExternalAreaIcon;
