import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FilterIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.5 7.203C9.82622 7.2029 9.16965 6.9902 8.62381 6.59518C8.07798 6.20017 7.6707 5.64299 7.46 5.003H1C0.734784 5.003 0.48043 4.89764 0.292893 4.71011C0.105357 4.52257 0 4.26822 0 4.003C0 3.73778 0.105357 3.48343 0.292893 3.29589C0.48043 3.10836 0.734784 3.003 1 3.003H7.46C7.67094 2.36327 8.07832 1.8064 8.62414 1.41165C9.16996 1.0169 9.82639 0.804398 10.5 0.804398C11.1736 0.804398 11.83 1.0169 12.3759 1.41165C12.9217 1.8064 13.3291 2.36327 13.54 3.003H15C15.2652 3.003 15.5196 3.10836 15.7071 3.29589C15.8946 3.48343 16 3.73778 16 4.003C16 4.26822 15.8946 4.52257 15.7071 4.71011C15.5196 4.89764 15.2652 5.003 15 5.003H13.54C13.3293 5.64299 12.922 6.20017 12.3762 6.59518C11.8303 6.9902 11.1738 7.2029 10.5 7.203ZM1 11.003C0.734784 11.003 0.48043 11.1084 0.292893 11.2959C0.105357 11.4834 0 11.7378 0 12.003C0 12.2682 0.105357 12.5226 0.292893 12.7101C0.48043 12.8976 0.734784 13.003 1 13.003H2.46C2.67094 13.6427 3.07832 14.1996 3.62414 14.5944C4.16996 14.9891 4.82639 15.2016 5.5 15.2016C6.17361 15.2016 6.83004 14.9891 7.37586 14.5944C7.92168 14.1996 8.32906 13.6427 8.54 13.003H15C15.2652 13.003 15.5196 12.8976 15.7071 12.7101C15.8946 12.5226 16 12.2682 16 12.003C16 11.7378 15.8946 11.4834 15.7071 11.2959C15.5196 11.1084 15.2652 11.003 15 11.003H8.54C8.32906 10.3633 7.92168 9.8064 7.37586 9.41165C6.83004 9.0169 6.17361 8.8044 5.5 8.8044C4.82639 8.8044 4.16996 9.0169 3.62414 9.41165C3.07832 9.8064 2.67094 10.3633 2.46 11.003H1ZM6.9 12.003C6.9 12.3743 6.7525 12.7304 6.48995 12.9929C6.2274 13.2555 5.8713 13.403 5.5 13.403C5.1287 13.403 4.7726 13.2555 4.51005 12.9929C4.2475 12.7304 4.1 12.3743 4.1 12.003C4.1 11.6317 4.2475 11.2756 4.51005 11.0131C4.7726 10.7505 5.1287 10.603 5.5 10.603C5.8713 10.603 6.2274 10.7505 6.48995 11.0131C6.7525 11.2756 6.9 11.6317 6.9 12.003ZM11.9 4.003C11.9 4.18685 11.8638 4.3689 11.7934 4.53876C11.7231 4.70861 11.62 4.86295 11.4899 4.99295C11.3599 5.12295 11.2056 5.22608 11.0358 5.29643C10.8659 5.36679 10.6839 5.403 10.5 5.403C10.3161 5.403 10.1341 5.36679 9.96424 5.29643C9.79439 5.22608 9.64005 5.12295 9.51005 4.99295C9.38005 4.86295 9.27693 4.70861 9.20657 4.53876C9.13621 4.3689 9.1 4.18685 9.1 4.003C9.1 3.6317 9.2475 3.2756 9.51005 3.01305C9.7726 2.7505 10.1287 2.603 10.5 2.603C10.8713 2.603 11.2274 2.7505 11.4899 3.01305C11.7525 3.2756 11.9 3.6317 11.9 4.003Z"
            fill={props.fill}
        />
    </svg>
);

FilterIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default FilterIcon;
