import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FullscreenIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M12.3 2.78591V2.46253L11.1503 2.77684C10.6125 2.92385 10.0575 2.99835 9.5 2.99835C8.9 2.99835 8.5 2.55063 8.5 1.99725C8.5 1.44497 8.94772 0.997253 9.5 0.997253H14C14.5523 0.997253 15 1.44497 15 1.99725V6.50176C15 7.05405 14.5523 7.50176 14 7.50176C13.4477 7.50176 13 7.09903 13 6.50176C13 5.94244 13.0747 5.38562 13.222 4.84607L13.5353 3.69903H13.2144L12.1366 5.13591C11.8524 5.51489 11.5415 5.87319 11.2065 6.20811L10.2042 7.21027C9.81361 7.60072 9.18045 7.60059 8.79 7.20999C8.39955 6.81939 8.39968 6.18623 8.79028 5.79578L9.79386 4.79232C10.1265 4.45985 10.4821 4.15125 10.8581 3.86883L12.3 2.78591ZM3.7 13.2044V13.5277L4.84973 13.2134C5.3875 13.0664 5.9425 12.9919 6.5 12.9919C7.1 12.9919 7.5 13.4396 7.5 13.993C7.5 14.5453 7.05228 14.993 6.5 14.993H2C1.44772 14.993 1 14.5453 1 13.993V9.48851C1 8.93623 1.44772 8.48851 2 8.48851C2.55228 8.48851 3 8.89125 3 9.48851C3 10.0478 2.92533 10.6047 2.77795 11.1442L2.46466 12.2913H2.78564L3.86338 10.8544C4.14763 10.4754 4.45846 10.1171 4.7935 9.78216L5.79579 8.78001C6.18639 8.38956 6.81955 8.38968 7.21 8.78028C7.60045 9.17089 7.60032 9.80405 7.20972 10.1945L6.20614 11.198C5.87354 11.5304 5.5179 11.839 5.14187 12.1214L3.7 13.2044Z"
            fill={props.fill}
        />
    </svg>
);

FullscreenIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default FullscreenIcon;
