import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const GlobeIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M0 8C0 12.4183 3.58172 16 8 16C12.4183 16 16 12.4183 16 8C16 3.58172 12.4183 0 8 0C3.58172 0 0 3.58172 0 8ZM8 1.71429C6.7351 1.71429 5.55746 2.08791 4.57143 2.73082V3.65714C4.57143 4.16209 4.98077 4.57143 5.48571 4.57143H9.37143C9.87638 4.57143 10.2857 4.98077 10.2857 5.48571V6.47843C10.2857 6.72092 10.382 6.95347 10.5535 7.12493L10.9626 7.53403C11.2409 7.8123 11.666 7.88129 12.018 7.7053L13.2089 7.10985C13.5186 6.95497 13.7143 6.63839 13.7143 6.29208V5.37773C12.7204 3.21557 10.5355 1.71429 8 1.71429ZM6.61569 14.1328C7.06109 14.2329 7.52438 14.2857 8 14.2857C8.14789 14.2857 8.2946 14.2806 8.43994 14.2706L10.9528 10.9201C11.2258 10.5561 11.1896 10.0467 10.8679 9.72501L8.26779 7.12493C8.09633 6.95347 7.86377 6.85714 7.62129 6.85714H4.08755C3.69401 6.85714 3.34463 7.10897 3.22018 7.48231L2.57484 9.41835C2.41516 9.89738 2.67405 10.4152 3.15308 10.5748L5.2806 11.284C5.55361 11.375 5.76784 11.5892 5.85885 11.8623L6.61569 14.1328Z"
            fill={props.fill}
        />
    </svg>
);

GlobeIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default GlobeIcon;
