import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const GloveIcon = (props: IIconProps): ReactElement => (
    <svg
        width={props.width}
        height={props.height}
        viewBox="0 0 16 16"
        fill="none"
        focusable={false}
        xmlns="http://www.w3.org/2000/svg"
    >
        <path
            d="M11.921 14.1488C11.924 14.9486 11.921 15.9512 11.921 15.9512C11.921 15.9512 10.891 16.4754 8.75972 16.4754C6.56071 16.4754 5.22617 15.9512 5.22617 15.9512C5.22617 13.6338 4.96868 13.3763 4.46794 12.3775C3.76301 10.9713 2.71263 8.75233 2.71263 8.75233C2.45958 8.34175 2.61759 7.79285 3.07404 7.563C3.5078 7.37891 3.89701 7.51488 4.24169 7.97091L5.13828 9.27081C5.45984 9.65835 5.80196 9.42883 5.80068 9.08606C5.82125 8.46901 5.79685 8.05776 5.81699 7.32645C5.83713 6.59514 5.57301 3.2139 5.57301 3.2139C5.54861 2.80264 5.913 2.4131 6.32449 2.38904C6.73597 2.36499 7.14873 2.6837 7.15044 3.14072L7.41754 7.32176C7.41797 7.43602 7.4869 7.52722 7.60123 7.52689L7.71555 7.52655C7.87569 7.54894 7.98959 7.43435 7.98917 7.32009L8.19908 2.29215C8.24319 1.85784 8.56219 1.55984 9.01949 1.5585C9.43097 1.53444 9.75253 1.92198 9.73112 2.31051L9.52206 7.56697C9.49979 7.72699 9.61454 7.84091 9.72887 7.84058C9.84319 7.84025 10.0029 7.74837 10.0025 7.63412L10.6718 3.17612C10.7159 2.74181 11.172 2.3977 11.5839 2.4879C11.9958 2.5781 12.2715 2.94292 12.2274 3.37722L11.5808 7.78945C11.5812 7.90371 11.6732 8.0634 11.7876 8.06307C11.8792 8.1085 11.9931 7.99391 12.0385 7.90237L12.8033 4.51811C12.8932 4.10652 13.3038 3.85395 13.7158 3.94415C14.1735 4.05707 14.4265 4.46766 14.3366 4.87925C14.3366 4.87925 13.368 8.78969 12.9398 10.4591C12.6696 11.5796 11.9167 13.0062 11.921 14.1488Z"
            fill={props.fill}
        />
    </svg>
);

GloveIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default GloveIcon;
