import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HeartFilledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M8.39 15.246C8.27511 15.3246 8.13918 15.3666 8 15.3666C7.86082 15.3666 7.72489 15.3246 7.61 15.246C6.006 14.167 0 9.85503 0 5.78203C0 0.438032 6.28 -0.417969 8 3.18203C9.72 -0.417969 16 0.438032 16 5.78203C16 9.85503 9.994 14.167 8.39 15.246Z"
            fill={props.fill}
        />
    </svg>
);

HeartFilledIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default HeartFilledIcon;
