import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HeartOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8.509 15.309C13.448 12.389 16 9.27 16 5.893C16 1.106 10.71 -0.470999 8 2.519C5.29 -0.470999 0 1.106 0 5.893C0 9.27 2.552 12.39 7.491 15.309C7.64514 15.4002 7.82093 15.4482 8 15.4482C8.17907 15.4482 8.35486 15.4002 8.509 15.309ZM8.911 4.749C10.188 1.93 14 2.668 14 5.893C14 8.306 12.049 10.786 8 13.28C3.951 10.786 2 8.306 2 5.893C2 2.668 5.812 1.929 7.089 4.749C7.444 5.533 8.556 5.533 8.911 4.749Z"
            fill={props.fill}
        />
    </svg>
);

HeartOutlineIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default HeartOutlineIcon;
