import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HotelFeaturesIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10 7.46487V4C10 2.89543 9.10457 2 8 2C6.89543 2 6 2.89543 6 4C6 4.55228 5.55228 5 5 5C4.44772 5 4 4.55228 4 4C4 1.79086 5.79086 0 8 0C10.2091 0 12 1.79086 12 4C12 5.48056 11.1956 6.77325 10 7.46487Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.17001 6.9454C5.0078 7.08091 4 8.00352 4 9.1736V14.5C4 15.3284 4.67157 16 5.5 16H10.5C11.3284 16 12 15.3284 12 14.5V4H10C10 6.07657 7.88794 6.74509 6.17001 6.9454ZM6.63341 14.2177L7.99459 13.3473L9.36105 14.2189C9.40738 14.2484 9.46321 14.2574 9.51598 14.2438C9.62457 14.2158 9.69073 14.1017 9.66374 13.989L9.26906 12.3405L10.4221 11.406C10.4667 11.3699 10.4946 11.3161 10.4993 11.2576C10.5085 11.1419 10.4256 11.0403 10.3141 11.0307L8.80296 10.901L8.18382 9.37856C8.16336 9.32826 8.12486 9.28819 8.07646 9.26683C7.97349 9.22138 7.85452 9.27116 7.81073 9.37802L7.18658 10.901L5.68581 11.0306C5.62965 11.0355 5.57798 11.0644 5.5432 11.1104C5.47414 11.2017 5.48952 11.3339 5.57756 11.4056L6.72594 12.3405L6.33055 13.9879C6.31738 14.0428 6.32607 14.1008 6.35466 14.149C6.41335 14.2479 6.53815 14.2786 6.63341 14.2177Z"
            fill={props.fill}
        />
    </svg>
);

HotelFeaturesIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default HotelFeaturesIcon;
