import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HygieneKitIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#51c56ebb__clip0_20315_4892)">
            <path
                d="M7.42999 2.71002H5.12C4.89454 2.70913 4.67698 2.79286 4.51031 2.9447C4.34365 3.09655 4.24007 3.30546 4.22003 3.53003L3 15.98H9.54999L8.33002 3.5C8.299 3.28257 8.19119 3.08343 8.02612 2.93854C7.86106 2.79365 7.64961 2.71259 7.42999 2.71002Z"
                fill={props.fill}
            />
            <path
                d="M7.85 1.82H4.7C4.52327 1.82 4.38 1.67673 4.38 1.5V0.319986C4.38 0.143255 4.52327 -1.34706e-05 4.7 -1.34706e-05H7.85C8.02674 -1.34706e-05 8.17 0.143255 8.17 0.319986V1.5C8.17 1.67673 8.02674 1.82 7.85 1.82Z"
                fill={props.fill}
            />
            <path
                d="M12.22 16C12.1212 16.0013 12.023 15.9828 11.9314 15.9456C11.8398 15.9084 11.7566 15.8532 11.6867 15.7833C11.6168 15.7134 11.5616 15.6302 11.5244 15.5386C11.4872 15.447 11.4687 15.3489 11.47 15.25V7.83002C11.4652 7.77345 11.4652 7.71654 11.47 7.65997L12.53 4.85999V0.75C12.53 0.551088 12.6091 0.360318 12.7497 0.219666C12.8904 0.0790132 13.0811 0 13.28 0C13.479 0 13.6697 0.0790132 13.8104 0.219666C13.951 0.360318 14.03 0.551088 14.03 0.75V4.94C14.0349 4.99323 14.0349 5.04675 14.03 5.09998L12.98 7.90997V15.25C12.98 15.3493 12.9603 15.4477 12.922 15.5393C12.8837 15.631 12.8276 15.7141 12.7569 15.7839C12.6861 15.8537 12.6022 15.9087 12.5101 15.9458C12.4179 15.9829 12.3194 16.0013 12.22 16Z"
                fill={props.fill}
            />
            <path
                d="M12.05 4.77997H10.72C10.72 4.25997 10.91 4.05997 10.91 3.77997C10.91 3.49997 10.72 2.77999 10.72 2.48999C10.72 2.19999 10.91 1.73002 10.91 1.40002C10.8217 0.994274 10.7583 0.583468 10.72 0.169983H12.05V4.77997Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="51c56ebb__clip0_20315_4892">
                <rect width={16} height={16} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

HygieneKitIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default HygieneKitIcon;
