import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const IncludeIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M13.7503 3.84004C14.1172 3.42725 14.7475 3.38312 15.1603 3.75004C15.5731 4.11695 15.6172 4.74725 15.2503 5.16004L8.11448 12.0018C8.06434 12.0564 8.06434 12.0564 8.01071 12.1076C7.40195 12.6694 6.45296 12.6314 5.89109 12.0226L2.75985 8.68004C2.38527 8.27419 2.41367 7.63461 2.81952 7.26004C3.22536 6.88546 3.85542 6.91419 4.23 7.32004L6.9864 10.2605L13.7503 3.84004Z"
            fill={props.fill}
        />
    </svg>
);

IncludeIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default IncludeIcon;
