import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const InfoIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M0 8C0 12.4183 3.58172 16 8 16C12.4183 16 16 12.4183 16 8C16 3.58172 12.4183 0 8 0C3.58172 0 0 3.58172 0 8ZM15 8C15 11.866 11.866 15 8 15C4.13401 15 1 11.866 1 8C1 4.13401 4.13401 1 8 1C11.866 1 15 4.13401 15 8Z"
            fill={props.fill}
        />
        <path
            d="M10.5 6.19372C10.5 6.54297 10.4454 6.83765 10.3363 7.07776C10.2271 7.31787 10.0889 7.52524 9.92156 7.69986C9.76148 7.86721 9.58686 8.01273 9.39768 8.13643C9.2085 8.26012 9.03024 8.37653 8.86289 8.48567C8.70282 8.59482 8.56821 8.70759 8.45907 8.82401C8.34993 8.94043 8.29536 9.07867 8.29536 9.23875V9.47885H6.86562V9.24966C6.86562 8.93679 6.91655 8.67849 7.01842 8.47476C7.12028 8.27103 7.24397 8.09641 7.3895 7.95089C7.54229 7.80537 7.706 7.68167 7.88063 7.57981C8.06253 7.47067 8.22624 7.35789 8.37176 7.24147C8.52456 7.11778 8.65189 6.97954 8.75375 6.82674C8.85562 6.66667 8.90655 6.46294 8.90655 6.21555C8.90655 6.08458 8.88836 5.96089 8.85198 5.84447C8.8156 5.72078 8.75011 5.61164 8.65553 5.51705C8.56094 5.42246 8.42633 5.34607 8.2517 5.28786C8.08436 5.22965 7.86608 5.20055 7.59686 5.20055C7.26944 5.20055 6.98568 5.24056 6.74557 5.3206C6.50546 5.39336 6.309 5.48067 6.15621 5.58254V4.37108C6.32356 4.28376 6.54911 4.20009 6.83288 4.12005C7.11664 4.04002 7.46589 4 7.88063 4C8.31719 4 8.69918 4.05457 9.0266 4.16371C9.35402 4.26557 9.62688 4.41473 9.84516 4.61119C10.0634 4.80036 10.2271 5.02956 10.3363 5.29877C10.4454 5.56799 10.5 5.8663 10.5 6.19372ZM7.60778 12C7.46953 12 7.33856 11.9745 7.21487 11.9236C7.09845 11.8727 6.99295 11.8035 6.89836 11.7162C6.81105 11.6216 6.74193 11.5161 6.691 11.3997C6.64006 11.2833 6.6146 11.1596 6.6146 11.0286C6.6146 10.8977 6.64006 10.774 6.691 10.6576C6.74193 10.5412 6.81105 10.4393 6.89836 10.352C6.99295 10.2647 7.09845 10.1955 7.21487 10.1446C7.33856 10.0937 7.46953 10.0682 7.60778 10.0682C7.74602 10.0682 7.87699 10.0937 8.00068 10.1446C8.12437 10.1955 8.22988 10.2647 8.31719 10.352C8.41178 10.4393 8.48454 10.5412 8.53547 10.6576C8.5864 10.774 8.61187 10.8977 8.61187 11.0286C8.61187 11.1596 8.5864 11.2833 8.53547 11.3997C8.48454 11.5161 8.41178 11.6216 8.31719 11.7162C8.22988 11.8035 8.12437 11.8727 8.00068 11.9236C7.87699 11.9745 7.74602 12 7.60778 12Z"
            fill={props.fill}
        />
    </svg>
);

InfoIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default InfoIcon;
