import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const KitchenIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M12.6667 2H15.3333C15.7015 2 16 2.29848 16 2.66667V12C16 12.3682 15.7015 12.6667 15.3333 12.6667H12.6667V2Z"
            fill={props.fill}
        />
        <path
            d="M0 2.66667C0 2.29848 0.298477 2 0.666667 2H11.3333C11.7015 2 12 2.29848 12 2.66667V12C12 12.3682 11.7015 12.6667 11.3333 12.6667H0.666667C0.298477 12.6667 0 12.3682 0 12V2.66667Z"
            fill={props.fill}
        />
        <path
            d="M2 12.6667H4V13.6667C4 13.8508 3.85076 14 3.66667 14H2.33333C2.14924 14 2 13.8508 2 13.6667V12.6667Z"
            fill={props.fill}
        />
        <path
            d="M12.6667 12.6667H14.6667V13.6667C14.6667 13.8508 14.5174 14 14.3333 14H13C12.8159 14 12.6667 13.8508 12.6667 13.6667V12.6667Z"
            fill={props.fill}
        />
        <path
            d="M6.51879 3.80474C6.77914 3.54439 7.20125 3.54439 7.4616 3.80474C7.72195 4.06509 7.72195 4.4872 7.4616 4.74755L2.74755 9.46159C2.4872 9.72194 2.06509 9.72194 1.80474 9.46159C1.54439 9.20124 1.54439 8.77913 1.80474 8.51878L6.51879 3.80474Z"
            fill={props.fill}
        />
        <path
            d="M9.29984 4.4714C9.56019 4.21106 9.9823 4.21106 10.2426 4.4714C10.503 4.73175 10.503 5.15386 10.2426 5.41421L7.41422 8.24264C7.15387 8.50299 6.73176 8.50299 6.47141 8.24264C6.21106 7.98229 6.21106 7.56018 6.47141 7.29983L9.29984 4.4714Z"
            fill={props.fill}
        />
        <path
            d="M15.3333 5C15.3333 5.55228 14.8856 6 14.3333 6C13.781 6 13.3333 5.55228 13.3333 5C13.3333 4.44772 13.781 4 14.3333 4C14.8856 4 15.3333 4.44772 15.3333 5Z"
            fill={props.fill}
        />
        <path
            d="M13.3333 10C13.3333 9.63181 13.6318 9.33333 14 9.33333H14.6667C15.0349 9.33333 15.3333 9.63181 15.3333 10V10.6667C15.3333 11.0349 15.0349 11.3333 14.6667 11.3333H14C13.6318 11.3333 13.3333 11.0349 13.3333 10.6667V10Z"
            fill={props.fill}
        />
        <path
            d="M13.3333 6.8C13.3333 6.72636 13.393 6.66667 13.4667 6.66667H13.8667C13.9403 6.66667 14 6.72636 14 6.8V7.2C14 7.27364 13.9403 7.33333 13.8667 7.33333H13.4667C13.393 7.33333 13.3333 7.27364 13.3333 7.2V6.8Z"
            fill={props.fill}
        />
        <path
            d="M14.6667 6.8C14.6667 6.72636 14.7264 6.66667 14.8 6.66667H15.2C15.2736 6.66667 15.3333 6.72636 15.3333 6.8V7.2C15.3333 7.27364 15.2736 7.33333 15.2 7.33333H14.8C14.7264 7.33333 14.6667 7.27364 14.6667 7.2V6.8Z"
            fill={props.fill}
        />
        <path
            d="M14.6667 8.13333C14.6667 8.0597 14.7264 8 14.8 8H15.2C15.2736 8 15.3333 8.0597 15.3333 8.13333V8.53333C15.3333 8.60697 15.2736 8.66667 15.2 8.66667H14.8C14.7264 8.66667 14.6667 8.60697 14.6667 8.53333V8.13333Z"
            fill={props.fill}
        />
        <path
            d="M13.3333 8.13333C13.3333 8.0597 13.393 8 13.4667 8H13.8667C13.9403 8 14 8.0597 14 8.13333V8.53333C14 8.60697 13.9403 8.66667 13.8667 8.66667H13.4667C13.393 8.66667 13.3333 8.60697 13.3333 8.53333V8.13333Z"
            fill={props.fill}
        />
        <rect
            x={1}
            y={8.65686}
            width={8}
            height={1}
            rx={0.5}
            transform="rotate(-45 1 8.65686)"
            fill="white"
        />
        <rect
            x={5}
            y={8.65686}
            width={5}
            height={1}
            rx={0.5}
            transform="rotate(-45 5 8.65686)"
            fill="white"
        />
        <path
            d="M15.818 5.48901C15.818 6.31744 15.1464 6.98901 14.318 6.98901C13.4896 6.98901 12.818 6.31744 12.818 5.48901C12.818 4.66059 13.4896 3.98901 14.318 3.98901C15.1464 3.98901 15.818 4.66059 15.818 5.48901Z"
            fill="white"
        />
    </svg>
);

KitchenIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default KitchenIcon;
