import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const LocationIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M0.889838 6.99873C0.889838 3.13316 4.07367 0 8.00056 0C11.9275 0 15.1113 3.13405 15.1113 6.99962C15.1113 9.75325 13.4963 12.1353 11.1471 13.2784C9.61203 14.0632 8.71314 14.8836 8.39938 15.7387C8.34222 15.8956 8.16755 16 8.00056 16C7.83358 16 7.65659 15.8956 7.59943 15.7387C7.28567 14.8836 6.3891 14.0632 4.85407 13.2784C2.50575 12.1345 0.889838 9.75236 0.889838 6.99873ZM7.99954 8.99862C9.12126 8.99862 10.0314 8.10356 10.0314 6.99873C10.0314 5.8939 9.12126 4.99973 7.99954 4.99973C6.87783 4.99973 5.96765 5.89479 5.96765 6.99962C5.96765 8.10445 6.87783 8.99951 7.99954 8.99951V8.99862Z"
            fill={props.fill}
        />
    </svg>
);

LocationIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default LocationIcon;
