import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MirCardIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 37 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M9.06249 13L10.7578 7.14795C10.7728 7.05243 10.8514 6.97959 10.9462 6.97959C11.0517 6.97959 11.1372 7.06982 11.1372 7.18112V7.18367V13H14.0378V3H11.5483H10.807C10.2732 3 9.71409 3.43676 9.55801 3.97552L8.14632 8.8485C8.07616 9.0907 7.9622 9.09096 7.89197 8.8485L6.48028 3.97552C6.32431 3.43713 5.76499 3 5.23125 3H4.48976H2V13H4.90069L4.9007 7.18367L4.90069 7.18112C4.90069 7.06982 4.98618 6.97959 5.09165 6.97959C5.18523 6.97959 5.26309 7.05063 5.27945 7.1444L6.9758 13H9.06249ZM21.5893 6.97702L21.5916 6.97188C21.6213 6.91556 21.6786 6.87755 21.7441 6.87755C21.8386 6.87755 21.9155 6.95703 21.918 7.05611L21.9181 13H24.8188V3H21.9181C21.5503 3.01292 21.1347 3.29779 20.9802 3.64746L18.6718 8.87179C18.6661 8.89315 18.6572 8.91308 18.6456 8.93098L18.6448 8.93273C18.6099 8.98578 18.5515 9.02041 18.4856 9.02041C18.3788 9.02041 18.2922 8.92904 18.2922 8.81633V3H15.3916V13H18.2922V12.9989C18.6561 12.9788 19.0619 12.6971 19.2142 12.3525L21.5834 6.99049C21.5852 6.9859 21.5872 6.98141 21.5893 6.97702ZM30.5359 7.03061C28.07 7.03061 26.051 5.25227 25.8821 3L32.4455 3.00009C34.2099 3.0138 35.6363 4.52714 35.6363 6.39286C35.6363 6.61086 35.6168 6.82405 35.5796 7.03061H30.5359ZM26.2691 12.9984V7.54146H35.4594C35.0162 8.84277 33.8409 9.77552 32.4573 9.78636H29.1698V12.9984H26.2691Z"
            fill={props.fill}
        />
    </svg>
);

MirCardIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default MirCardIcon;
