import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const NoOnlineRegistrationIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M13.4433 9.51573C13.869 9.42393 14.2316 9.26983 14.531 9.05344C15.0596 8.67759 15.4366 8.18216 15.662 7.56713C15.8873 6.94071 15.9999 6.27443 15.9999 5.56829C15.9999 4.3838 15.7226 3.45556 15.168 2.78359C14.622 2.10022 13.751 1.75854 12.555 1.75854H10.5911C10.0388 1.75854 9.59109 2.20625 9.59109 2.75852V6.6129L13.4433 9.51573ZM8.20393 5.5676C8.01945 4.64563 7.71119 3.87138 7.27915 3.24486C6.52516 2.14009 5.46352 1.5877 4.09422 1.5877C3.7314 1.5877 3.38211 1.61883 3.04636 1.68109L8.20393 5.5676ZM1.18683 2.95498C1.19005 3.03776 1.20369 3.12132 1.2283 3.2035L1.26784 3.33558C1.43877 3.90655 2.06196 4.18963 2.63058 4.04292L1.18683 2.95498ZM6.21914 6.74709L8.40072 8.39103C8.36216 9.43175 8.20496 10.3587 7.92913 11.1719C7.60847 12.1058 7.11448 12.8347 6.44716 13.3586C5.78851 13.8712 4.94353 14.1274 3.91222 14.1274C3.38357 14.1274 2.90258 14.0762 2.46925 13.9737C2.22916 13.9157 1.98629 13.8395 1.74065 13.7452C1.38426 13.6083 1.16928 13.2533 1.16928 12.8715V12.7729C1.16928 12.084 1.86973 11.622 2.53425 11.804C2.95891 11.9179 3.37923 11.9748 3.79522 11.9748C4.59254 11.9748 5.20786 11.7186 5.64118 11.206C6.07451 10.6821 6.3085 9.90195 6.34317 8.86552H3.31324C2.76096 8.86552 2.31326 8.41781 2.31326 7.86554V7.74707C2.31326 7.1948 2.76096 6.74709 3.31324 6.74709H6.21914ZM9.59109 9.28804L11.554 10.7672V12.9751C11.554 13.5172 11.1146 13.9566 10.5726 13.9566C10.0305 13.9566 9.59109 13.5172 9.59109 12.9751V9.28804ZM11.554 3.87697H12.451C13.491 3.87697 14.011 4.46922 14.011 5.65371C14.011 6.30291 13.8463 6.77557 13.517 7.07169C13.1963 7.35643 12.7587 7.49879 12.204 7.49879H11.554V3.87697Z"
            fill="#FF0000"
        />
        <path
            d="M14.8941 14.6439C14.6517 14.6802 14.4047 14.6197 14.2064 14.4756L0.480358 4.1323C0.287188 3.9814 0.161013 3.76067 0.12901 3.51764C0.0970057 3.27462 0.161733 3.02875 0.309252 2.83298C0.45677 2.63722 0.675276 2.50723 0.917707 2.47101C1.16014 2.43478 1.4071 2.49523 1.60539 2.63932L15.3315 12.9827C15.5246 13.1336 15.6508 13.3543 15.6828 13.5973C15.7148 13.8403 15.6501 14.0862 15.5026 14.282C15.355 14.4777 15.1365 14.6077 14.8941 14.6439Z"
            fill="#FF0000"
        />
    </svg>
);

NoOnlineRegistrationIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default NoOnlineRegistrationIcon;
