import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const OrdersFilledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M5.5 3.5C5.5 2.11929 6.61929 1 8 1C9.38071 1 10.5 2.11929 10.5 3.5V5H5.5V3.5Z"
            stroke={props.fill}
            strokeWidth={2}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M1 7C1 5.34315 2.34315 4 4 4H12C13.6569 4 15 5.34315 15 7V12C15 13.6569 13.6569 15 12 15H4C2.34315 15 1 13.6569 1 12V7Z"
            fill={props.fill}
        />
    </svg>
);

OrdersFilledIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default OrdersFilledIcon;
