import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PlaidIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M11.9212 1.69995H8.70414C8.05875 1.69994 7.43963 1.95546 6.98206 2.41061C6.52449 2.86576 6.26567 3.48352 6.26226 4.1289V8.94807C6.26226 9.56143 6.50593 10.1496 6.93964 10.5833C7.37334 11.017 7.96161 11.2607 8.57497 11.2607H11.7159C11.8322 11.2753 11.9504 11.265 12.0625 11.2305C12.1746 11.196 12.278 11.138 12.366 11.0604C12.4539 10.9828 12.5243 10.8874 12.5726 10.7805C12.6208 10.6736 12.6459 10.5576 12.6459 10.4403C12.6459 10.323 12.6208 10.207 12.5726 10.1001C12.5243 9.99318 12.4539 9.89782 12.366 9.82023C12.278 9.74263 12.1746 9.68459 12.0625 9.65006C11.9504 9.61552 11.8322 9.60522 11.7159 9.61985H8.50003C8.3287 9.61985 8.16444 9.55182 8.04329 9.43068C7.92214 9.30953 7.85404 9.14519 7.85404 8.97386C7.85404 8.80253 7.92214 8.63827 8.04329 8.51712C8.16444 8.39597 8.3287 8.32786 8.50003 8.32786H11.7159C12.0072 8.30507 12.3 8.34276 12.576 8.43858C12.8521 8.5344 13.1053 8.68629 13.3198 8.88467C13.5343 9.08305 13.7054 9.32368 13.8224 9.59139C13.9395 9.8591 14 10.1481 14 10.4403C14 10.7325 13.9395 11.0215 13.8224 11.2892C13.7054 11.5569 13.5343 11.7975 13.3198 11.9959C13.1053 12.1943 12.8521 12.3462 12.576 12.442C12.3 12.5378 12.0072 12.5755 11.7159 12.5527H8.57497C7.61896 12.5527 6.70216 12.1729 6.02616 11.4969C5.35016 10.8209 4.97027 9.90409 4.97027 8.94807V4.14183H1.0943C0.92297 4.14183 0.758707 4.20994 0.63756 4.33109C0.516412 4.45223 0.448303 4.6165 0.448303 4.78783C0.448303 4.95915 0.516412 5.12349 0.63756 5.24464C0.758707 5.36579 0.92297 5.43382 1.0943 5.43382H2.59305V7.06174H1.0943C0.92297 7.06174 0.758707 7.12977 0.63756 7.25092C0.516412 7.37206 0.448303 7.53641 0.448303 7.70773C0.448303 7.87906 0.516412 8.0434 0.63756 8.16455C0.758707 8.2857 0.92297 8.35373 1.0943 8.35373H2.59305V9.98165H1.0943C0.92297 9.98165 0.758707 10.0497 0.63756 10.1708C0.516412 10.292 0.448303 10.4563 0.448303 10.6276C0.448303 10.799 0.516412 10.9632 0.63756 11.0844C0.758707 11.2055 0.92297 11.2736 1.0943 11.2736H2.59305V12.9532H1.0943C0.92297 12.9532 0.758707 13.0212 0.63756 13.1424C0.516412 13.2635 0.448303 13.4279 0.448303 13.5992C0.448303 13.7705 0.516412 13.9349 0.63756 14.056C0.758707 14.1772 0.92297 14.2452 1.0943 14.2452H11.8696C12.339 14.2452 12.8037 14.1525 13.2371 13.9725C13.6706 13.7925 14.0643 13.5287 14.3955 13.1962C14.7268 12.8638 14.9893 12.4691 15.1677 12.035C15.3462 11.6009 15.4371 11.1357 15.4354 10.6664V5.33044C15.4439 4.86107 15.3597 4.39468 15.1876 3.95794C15.0154 3.52119 14.7588 3.12272 14.4323 2.78541C14.1058 2.44811 13.7158 2.17862 13.2849 1.99235C12.854 1.80609 12.3906 1.70668 11.9212 1.69995Z"
            fill={props.fill}
        />
    </svg>
);

PlaidIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default PlaidIcon;
