import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PlaneIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#71393cf5__clip0_21009_4769)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M4.66874 9.75072C5.22876 9.05424 5.95024 8.19475 6.80506 7.25668L1.21238 3.52823C0.993266 3.38215 0.934057 3.08611 1.08013 2.86699L1.79309 1.79756C1.91817 1.60994 2.15756 1.53559 2.36692 1.61933L9.53246 4.48555C13.2522 1.00122 14.532 0.769154 14.8814 1.11858C15.2314 1.46853 14.9981 2.75168 11.4986 6.4845C10.1288 7.94558 7.83559 9.91685 6.24928 11.2369V14.3162C6.24928 14.4522 6.17244 14.5765 6.0508 14.6373L5.40146 14.962C5.22409 15.0507 5.00842 14.9788 4.91974 14.8014C4.91529 14.7925 4.91121 14.7834 4.90751 14.7742L3.8556 12.1444L1.2258 11.0925C1.04168 11.0188 0.95213 10.8099 1.02578 10.6258C1.02947 10.6165 1.03355 10.6074 1.038 10.5985L1.36267 9.9492C1.42349 9.82756 1.54782 9.75072 1.68382 9.75072H4.66874ZM11.9437 7.53995L14.3809 13.633C14.4646 13.8423 14.3903 14.0817 14.2027 14.2068L13.1332 14.9197C12.9141 15.0658 12.6181 15.0066 12.472 14.7875L9.25782 9.96625C10.0053 9.39165 10.7649 8.73472 11.4988 8.00084C11.6534 7.84623 11.8016 7.69254 11.9437 7.53995Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="71393cf5__clip0_21009_4769">
                <rect
                    width={14}
                    height={14}
                    fill="white"
                    transform="translate(1 1)"
                />
            </clipPath>
        </defs>
    </svg>
);

PlaneIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default PlaneIcon;
