import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PrintIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M5 1C4.44772 1 4 1.44772 4 2C4 2.55228 4.44772 3 5 3H11C11.5523 3 12 2.55228 12 2C12 1.44772 11.5523 1 11 1H5ZM2.5 4C1.67157 4 1 4.67157 1 5.5V11.5C1 12.3284 1.67157 13 2.5 13H4V13.5C4 14.3284 4.67157 15 5.5 15H10.5C11.3284 15 12 14.3284 12 13.5V13H13.5C14.3284 13 15 12.3284 15 11.5V5.5C15 4.67157 14.3284 4 13.5 4H2.5ZM10 9H6V13H10V9ZM12.125 8C12.7463 8 13.25 7.49632 13.25 6.875C13.25 6.25368 12.7463 5.75 12.125 5.75C11.5037 5.75 11 6.25368 11 6.875C11 7.49632 11.5037 8 12.125 8Z"
            fill={props.fill}
        />
    </svg>
);

PrintIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default PrintIcon;
