import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const RouteIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M3.4341 2.56545L6.23409 5.36544C6.38609 5.51744 6.59089 5.59984 6.79969 5.59984C6.86449 5.59984 6.93009 5.59264 6.99569 5.57584C7.26849 5.50704 7.48529 5.29984 7.56609 5.03024L8.76608 1.03025C8.85088 0.747855 8.77328 0.443056 8.56528 0.234257C8.35809 0.0262578 8.05409 -0.0505419 7.77009 0.0334578L3.7701 1.23345C3.5005 1.31505 3.2933 1.53185 3.2245 1.80465C3.1557 2.07745 3.2349 2.36625 3.4341 2.56545Z"
            fill={props.fill}
        />
        <path
            d="M2.36721 4.92576C1.00122 6.12645 0.806436 8.26001 1.92962 9.69978C3.06038 11.1493 5.122 11.3853 6.53476 10.2262L10.439 7.02321C11.1777 6.41722 12.2596 6.54146 12.8512 7.29979C13.4502 8.06761 13.3446 9.21953 12.6165 9.8595L11.7825 10.5926C11.4554 10.8802 11.4175 11.3852 11.6979 11.7206C11.9782 12.0561 12.4707 12.095 12.7979 11.8074L13.6319 11.0743C14.9986 9.873 15.1939 7.74164 14.0695 6.30028C12.94 4.85242 10.8764 4.61543 9.46435 5.77382L5.5601 8.97685C4.82047 9.58363 3.74064 9.46003 3.14794 8.70027C2.55005 7.93385 2.65541 6.77975 3.38259 6.14056L3.81594 5.80798C4.14306 5.52044 4.18433 5.01544 3.90394 4.67998C3.62355 4.34452 3.12707 4.30445 2.79995 4.59198L2.36721 4.92576Z"
            fill={props.fill}
        />
        <path
            d="M6.39993 13.6C6.39993 12.2745 7.47444 11.2 8.79992 11.2C10.1254 11.2 11.1999 12.2745 11.1999 13.6C11.1999 14.9255 10.1254 16 8.79992 16C7.47444 16 6.39993 14.9255 6.39993 13.6Z"
            fill={props.fill}
        />
    </svg>
);

RouteIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default RouteIcon;
