import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ShareOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12.7 6.40313C11.824 6.40313 11.0328 6.03976 10.469 5.45552L7.09719 7.10839C7.16426 7.36202 7.2 7.6284 7.2 7.90313C7.2 8.24166 7.14573 8.56753 7.04542 8.87249L10.469 10.5508C11.0328 9.9665 11.824 9.60313 12.7 9.60313C14.4121 9.60313 15.8 10.9911 15.8 12.7031C15.8 14.4152 14.4121 15.8031 12.7 15.8031C10.9879 15.8031 9.6 14.4152 9.6 12.7031C9.6 12.5876 9.60632 12.4735 9.61864 12.3613L5.80564 10.4921C5.31636 10.8151 4.73014 11.0031 4.1 11.0031C2.38792 11.0031 1 9.61521 1 7.90313C1 6.19104 2.38792 4.80313 4.1 4.80313C4.8035 4.80313 5.45226 5.03746 5.9725 5.43234L9.61864 3.64501C9.60632 3.53274 9.6 3.41867 9.6 3.30313C9.6 1.59104 10.9879 0.203125 12.7 0.203125C14.4121 0.203125 15.8 1.59104 15.8 3.30313C15.8 5.01521 14.4121 6.40313 12.7 6.40313ZM13.9 3.30313C13.9 3.96587 13.3627 4.50313 12.7 4.50313C12.0373 4.50313 11.5 3.96587 11.5 3.30313C11.5 2.64038 12.0373 2.10313 12.7 2.10313C13.3627 2.10313 13.9 2.64038 13.9 3.30313ZM12.7 13.9031C13.3627 13.9031 13.9 13.3659 13.9 12.7031C13.9 12.0404 13.3627 11.5031 12.7 11.5031C12.0373 11.5031 11.5 12.0404 11.5 12.7031C11.5 13.3659 12.0373 13.9031 12.7 13.9031ZM5.3 7.90313C5.3 8.56587 4.76274 9.10313 4.1 9.10313C3.43726 9.10313 2.9 8.56587 2.9 7.90313C2.9 7.24038 3.43726 6.70313 4.1 6.70313C4.76274 6.70313 5.3 7.24038 5.3 7.90313Z"
            fill={props.fill}
        />
    </svg>
);

ShareOutlineIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ShareOutlineIcon;
