import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ShildIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8.22363 0.1113C8.0826 0.0414642 7.9174 0.0414643 7.77637 0.1113C5.96972 1.00589 3.78401 1.96822 1.56846 2.01006C1.26697 2.01575 1.01949 2.26639 1.04149 2.56713L1.5 8.83443C1.5 10.3384 2.25442 11.7477 3.52113 12.6101L7.69825 15.7716C7.87674 15.9067 8.12326 15.9067 8.30175 15.7716L12.4789 12.6101C13.7456 11.7477 14.5 10.3384 14.5 8.83443L14.9585 2.56713C14.9805 2.26639 14.733 2.01575 14.4315 2.01006C12.216 1.96822 10.0303 1.00589 8.22363 0.1113ZM11.6355 5.2104C12.0619 5.53439 12.123 6.11612 11.7721 6.50973L8.06807 10.6636C7.8864 10.8673 7.61894 10.9895 7.33327 10.9994C7.0476 11.0092 6.77102 10.9057 6.5734 10.715L4.27741 8.49965C3.89563 8.13128 3.90965 7.54696 4.30872 7.19455C4.7078 6.84214 5.3408 6.85508 5.72258 7.22345L7.23983 8.68742L10.2279 5.33647C10.5789 4.94286 11.2091 4.88642 11.6355 5.2104Z"
            fill={props.fill}
        />
    </svg>
);

ShildIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ShildIcon;
