import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SmokingRoomIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M5.85944 0C6.74912 3.28346 6.48458 5.42476 5.06585 6.4239C3.64711 7.42305 2.52958 8.5173 1.71328 9.70666C1.39045 7.09828 1.8951 5.22015 3.22721 4.07227C4.55931 2.92439 5.43673 1.56697 5.85944 0ZM5.20344 9.15016L14.1762 4.97576C14.2905 4.92246 14.4262 4.97191 14.4795 5.08623L15.9741 8.29463C16.0274 8.40895 15.978 8.54484 15.8638 8.59815L5.85699 13.2552L4.65161 10.6677C4.38533 10.0961 4.63239 9.4167 5.20344 9.15016ZM1.79742 10.7521L3.0028 13.3396C3.26908 13.9112 3.02202 14.5906 2.45097 14.8571L1.24559 12.2697C0.979305 11.6981 1.22637 11.0187 1.79742 10.7521ZM3.54279 9.93382L4.74817 12.5212C5.01446 13.0928 4.76739 13.7723 4.19634 14.0388L2.99096 11.4514C2.72468 10.8798 2.97174 10.2004 3.54279 9.93382Z"
            fill={props.fill}
        />
    </svg>
);

SmokingRoomIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SmokingRoomIcon;
