import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SocialDistanceIcon = (props: IIconProps): ReactElement => (
    <svg
        width={props.width}
        height={props.height}
        viewBox="0 0 16 16"
        fill="none"
        focusable={false}
        xmlns="http://www.w3.org/2000/svg"
    >
        <g clipPath="url(#clip0)">
            <path
                d="M9.4 3.40341C9.4 4.17849 8.77733 4.80682 8 4.80682C7.22267 4.80682 6.59 4.17849 6.59 3.40341C6.59 2.62833 7.22267 2 8 2C8.77733 2 9.4 2.62833 9.4 3.40341Z"
                fill={props.fill}
            />
            <path
                d="M5.5 9.4233C5.5 10.0858 5.93018 10.6452 6.5 10.8854V13.4119C6.5 14.2983 7.11107 15 8 15C8.88893 15 9.5 14.3134 9.5 13.4639V10.8854C10.0092 10.6225 10.5003 10.0418 10.5003 9.4233V7.24432C10.5003 6.35796 9.79651 5.28693 8.90758 5.28693H7.09267C6.20374 5.28693 5.5 6.35796 5.5 7.24432V9.4233Z"
                fill={props.fill}
            />
            <path
                d="M1.9 3.40341C1.9 4.17849 1.27733 4.80682 0.5 4.80682C-0.27733 4.80682 -0.91 4.17849 -0.91 3.40341C-0.91 2.62833 -0.27733 2 0.5 2C1.27733 2 1.9 2.62833 1.9 3.40341Z"
                fill={props.fill}
            />
            <path
                d="M-2 9.4233C-2 10.0858 -1.56982 10.6452 -1 10.8854V13.4119C-1 14.2983 -0.388933 15 0.5 15C1.38893 15 2 14.3134 2 13.4639V10.8854C2.5092 10.6225 3.00026 10.0418 3.00026 9.4233V7.24432C3.00026 6.35796 2.29651 5.28693 1.40758 5.28693H-0.407325C-1.29626 5.28693 -2 6.35796 -2 7.24432V9.4233Z"
                fill={props.fill}
            />
            <path
                d="M16.9 3.40341C16.9 4.17849 16.2773 4.80682 15.5 4.80682C14.7227 4.80682 14.09 4.17849 14.09 3.40341C14.09 2.62833 14.7227 2 15.5 2C16.2773 2 16.9 2.62833 16.9 3.40341Z"
                fill={props.fill}
            />
            <path
                d="M13 9.4233C13 10.0858 13.4302 10.6452 14 10.8854V13.4119C14 14.2983 14.6111 15 15.5 15C16.3889 15 17 14.3134 17 13.4639V10.8854C17.5092 10.6225 18.0003 10.0418 18.0003 9.4233V7.24432C18.0003 6.35796 17.2965 5.28693 16.4076 5.28693H14.5927C13.7037 5.28693 13 6.35796 13 7.24432V9.4233Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="clip0">
                <rect width={props.width} height={props.height} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

SocialDistanceIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SocialDistanceIcon;
