import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SortAscendingIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M1 14C0.447715 14 0 13.5523 0 13C0 12.4477 0.447715 12 1 12H15C15.5523 12 16 12.4477 16 13C16 13.5523 15.5523 14 15 14H1ZM0 8C0 8.55228 0.447715 9 1 9H11C11.5523 9 12 8.55228 12 8C12 7.44772 11.5523 7 11 7H1C0.447715 7 0 7.44772 0 8ZM0 3C0 3.55229 0.447715 4 1 4H7C7.55228 4 8 3.55229 8 3C8 2.44771 7.55228 2 7 2H1C0.447715 2 0 2.44771 0 3Z"
            fill={props.fill}
        />
    </svg>
);

SortAscendingIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SortAscendingIcon;
