import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const StarIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.09116 5.91284L7.66313 1.2367C7.72359 1.05684 7.92339 0.958435 8.10938 1.0169C8.21715 1.05078 8.30165 1.13249 8.33668 1.2367L9.90865 5.91284C9.93986 6.00567 10.0105 6.08121 10.103 6.12048L13.7882 7.68653C13.9672 7.76262 14.0486 7.96466 13.9699 8.13781C13.9342 8.21632 13.8694 8.27904 13.7882 8.31354L10.103 9.87959C10.0105 9.91886 9.93986 9.9944 9.90865 10.0872L8.33668 14.7634C8.27622 14.9432 8.07642 15.0416 7.89042 14.9832C7.78266 14.9493 7.69816 14.8676 7.66313 14.7634L6.09116 10.0872C6.05995 9.9944 5.98926 9.91886 5.89685 9.87959L2.21164 8.31354C2.03259 8.23745 1.95123 8.03541 2.02992 7.86226C2.0656 7.78374 2.13045 7.72104 2.21164 7.68653L5.89685 6.12048C5.98926 6.08121 6.05995 6.00567 6.09116 5.91284Z"
            fill={props.fill}
        />
    </svg>
);

StarIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default StarIcon;
